﻿<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie dla GUS Z-03</title>
		<script runat="server">

	//Dzień do któego zalicza się wypłaty za poprzedni kwartał
	static readonly int dataGraniczna = 11;
		    
    static string traceName = "";

    [DefaultWidth(10)]
    public enum Kwartał {
        Pierwszy    = 1,
        Drugi       = 2,
        Trzeci      = 3,
        Czwarty     = 4,
    }
    
    public class Params: ContextBase {
    
        public Params(Context context): base(context) {
            Date data = Date.Today;
            rok = data.Year;
            int m = data.Month-1;
            kwartał = (Kwartał)(m/3)+1;
            if ((m%3)==0) {
                kwartał-=1;
                if (kwartał==0) {
                    kwartał = Kwartał.Czwarty;
                    rok--;
                }
            }
        }
    
        int rok;
        [Required]
        [Priority(1)]
        public int Rok {
            get { return rok; }
            set {
                rok = value;
                OnChanged(EventArgs.Empty);
            }
        }
    
        Kwartał kwartał;
        [Priority(2)]
        [Required]
        public Kwartał Kwartał {
            get { return kwartał; }
            set {
                kwartał = value;
                OnChanged(EventArgs.Empty);
            }
        }
    
        [Priority(3)]
        [Browsable(false)]
        public int Months {
            get { return (int)kwartał * 3; }
        }
    
        [Priority(4)]
        [Caption("Raport za okres")]
        public FromTo Okres {
            get {
                Date from = new Date(rok, 1, 1);
                Date to = new Date(rok,(int)kwartał * 3 + 1, 1)-1;
                return new FromTo(from, to);
            }
        }
    }

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
            if (delegacja == null)
                delegacja = KalendModule.GetInstance(this).DefNieobecnosci[new Guid("00000000-0006-0005-0016-000000000000")];
        }

        //Jeżeli ustawiony true, to wszystkie liczby podawane bez zaokrąglenia
        //static bool debug = false;
        bool debug = false;
        [Priority(1)]
        [Caption("Liczby bez zaokrąglenia")]
        public bool Debug {
            get { return debug; }
            set {
                debug = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Po ustawieniu na true raport zostanie przygotowany dla pracowników zwróconych
        //przez listę a nie dla wszystkich
        //static bool wglisty = false;	
        bool wgListy = false;
        [Priority(2)]
        [Caption("Pracownicy wg listy")]
        public bool WgListy {
            get { return wgListy; }
            set {
                wgListy = value;
                OnChanged(EventArgs.Empty);
            }
        }

        string zapis = "";
        [Priority(3)]
        [Caption("Zapis obliczeń")]
        public string Zapis {
            get { return zapis; }
            set {
                zapis = value;
                OnChanged(EventArgs.Empty);
            }
        }

        DefinicjaNieobecnosci delegacja;
        [Priority(30)]
        [Caption("Delegacja służbowa")]
        public DefinicjaNieobecnosci Delegacja {
            get { return delegacja; }
            set {
                delegacja = value;
                OnChanged(EventArgs.Empty);
            }
        }
       public object GetListDelegacja() {
           return DefNieobecnosci.AktywneDefinicje(this);
        }
    }		
		              
    Params pars;
    [Context]
    public Params Pars {
        get { return pars; }
        set { pars = value; }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set {
            srpars = value;
            traceName = srpars.Zapis;
        }
    }		
		        
    class Total {
        public readonly string regon;
        readonly Params pars;
        readonly SrParams srpars;
        decimal etaty;
        public int osoby;
        public Time czas;
        public decimal brutto;
        public decimal spółdzielnie;
        public decimal budżet;
        public decimal zus;
        decimal interwencyjne;
        ///  public decimal fis;
    
        decimal[] wymiar = new decimal[12];
        decimal[] wymiar2 = new decimal[12];
        int[] days = new int[12];

        public Total(string regon, Params pars, SrParams srpars) {
            this.regon = regon;
            this.pars = pars;
            this.srpars = srpars;
            int y = pars.Okres.From.Year;
            for (int m=1; m<=12; m++) {
                YearMonth ym = new YearMonth(y, m);
                days[m-1] = ym.Days;
            }
        }
        
        public void AddBrutto(Pracownik p) {
            foreach (WypElement e in Elementy(p)) {
                try {
                    if (e.Wyplata.Typ!=TypWyplaty.Umowa 
                        && !e.ZasiłekBudżet 
                        && !e.ZasiłekZus 
                        && e.Definicja.Info.Opodatkowany
                        && e.Definicja.GUS.WykazujNaDeklaracjach
                    ) {
					    PracHistoria ph = e.PracHistoria;
					    if ((ph.Etat.RodzajZatrudnienia==RodzajZatrudnienia.NieDotyczy || ph.Etat.RodzajZatrudnienia==RodzajZatrudnienia.PracownikTymczasowy) /*&& (ph.Etat.OkresZatrudnienia*pars.Okres)!=FromTo.Empty*/) {
						    switch (e.Definicja.GUS.Kategoria) {
							    case KategoriaWynagrodzeniaGUS.WypłataUdziałWZysku:
								    spółdzielnie += e.Wartosc; break;
							    case KategoriaWynagrodzeniaGUS.DodatkoweWynagrodzenieRoczne:
								    budżet += e.Wartosc; break;
						    }
						    brutto += e.Wartosc;
						    zus += e.Podatki.KosztyZUS;
                            //TID: 3997
                            //fis += e.Podatki.ZalFIS + e.Podatki.ZdrowotneFaktycznieOdliczon e;
                            ///fis += e.Podatki.NalFIS;
                            Trace(string.Format("{0}, za okres: {1}, data wypłaty: {2}, wartość: {3}", e.Definicja.Nazwa, e.Okres, e.Data, e.Wartosc));
                        }
                    }
                }
                catch { Msg(); }
            }
        }
        
		ICollection AktualnyOkres(Pracownik p) {
            FromTo okres = EfektywnyOkres(p, pars.Okres);
            Trace("Aktualny okres: " + okres);
			ArrayList result = new ArrayList();
			
			//Elementy za okres sprawozawczy wypłacone do 11 dnia następnego okresu
			SubTable st = PlaceModule.GetInstance(p).WypElementy.WgPracownik[p];
			st = new SubTable(st, okres);
			FromTo ow1 = new FromTo(okres.From, okres.To + dataGraniczna);
			foreach (WypElement e in st) {
                try {
                    if (ow1.Contains(e.Data)) {
                        result.Add(e);
                        //Trace(string.Format("{0}, za okres: {1}, data wypłaty: {2}, wartość: {3}", e.Definicja.Nazwa, e.Okres, e.Data, e.Wartosc));
                    }
                }
                catch { Msg(); }
            }
					
			return result;
		}
		
		ICollection PoprzedniOkres(Pracownik p) {
            FromTo okres = EfektywnyOkres(p, pars.Okres);
            ArrayList result = new ArrayList();
			
			//Wypłaty wypłacone po 11 dniu okresu sprawozdawczego za okresy poprzednie
			FromTo ow1 = new FromTo(new Date(okres.From + dataGraniczna), Date.MaxValue);
			SubTable st = PlaceModule.GetInstance(p).WypElementy.WgDaty[p];
			st = new SubTable(st, ow1);
			FromTo ow2 = new FromTo(Date.MinValue, okres.From-1);
			FromTo ow3 = new FromTo(new Date(okres.From + dataGraniczna), new Date(okres.To + dataGraniczna));
            Trace("Poprzedni okres: " + ow1 + "/" + ow2);
            foreach (WypElement e in st) {
                try {
                    if (ow2.Contains(e.Okres.To) && ow3.Contains(e.Data)) {
                        result.Add(e);
                        Trace(string.Format("{0}, za okres: {1}, data wypłaty: {2}, wartość: {3}", e.Definicja.Nazwa, e.Okres, e.Data, e.Wartosc));
                    }
                }
                catch { Msg(); }
            }
					
			return result;
		}
		
		protected IEnumerable Elementy(Pracownik p) {
			ArrayList result = new ArrayList();
			result.AddRange(AktualnyOkres(p));
			result.AddRange(PoprzedniOkres(p));
			return result;
		}

        private Time DelegacjaGodz(FromTo zatr, Pracownik pracownik) {
            Time czas = Time.Zero;
            KalkulatorPracy kp = new KalkulatorPracy(pracownik);
            foreach (INieobecnosc n in kp.Nieobecnosci(zatr, true))
                if (n.Definicja == srpars.Delegacja) // delegacja służbowa
                    czas += ((OkresNieobecności)n).Norma().Czas;
            return czas;
        }

        //Do etatów wliczamy pracowników (bez uczniów, chałupników, agentów i pracowników
        //zatrudnionych za granicą) --> RodzajZatrudnienia=Nie dotyczy
        //Pomijamy okresy urlopów bezpłatnych.
        public void AddEtaty(PracHistoria ph, KalkulatorPracy kalk) {
            if (ph.Etat.RodzajZatrudnienia != RodzajZatrudnienia.NieDotyczy && ph.Etat.RodzajZatrudnienia != RodzajZatrudnienia.PracownikTymczasowy)
                return;

            FromTo zatr = EfektywnyOkres(ph) * pars.Okres;
            if (zatr == FromTo.Empty)
                return;

            czas += kalk.Praca(zatr).Czas + DelegacjaGodz(zatr, ph.Pracownik);      //TID: 8841, było p, nie bardzo wiem po co?
            
            decimal w = (decimal)ph.Etat.Zaszeregowanie.Wymiar;
            Periods p = zatr.ToPeriods();
            p = p.BreakByMonth();
            foreach (FromTo o in p) {
                int n = NieobecnyDni(ph.Pracownik, o);
                int m = o.From.Month - 1;
                decimal s = (w * (o.Days - n)) / days[m];
                wymiar[m] += s;
                if (ph.GUS.PraceInterwencyjne) wymiar2[m] += s;
            }
        }

        protected int NieobecnyDni(Pracownik pracownik, FromTo okres) {
            KalkulatorPracy kp = new KalkulatorPracy(pracownik);

            Periods on = Periods.Empty;
            Periods on14 = Periods.Empty;
            foreach (INieobecnosc n in kp.Nieobecnosci(okres, true))
                switch (n.Definicja.Przyczyna) {
                    case PrzyczynaNieobecnosci.UrlopWychowawczy:
                    case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                    case PrzyczynaNieobecnosci.UrlopBezpłatny:
                    //case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                    case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
                    case PrzyczynaNieobecnosci.UrlopMacierzyński:
                    case PrzyczynaNieobecnosci.UrlopRodzicielski:
                    case PrzyczynaNieobecnosci.UrlopOjcowski:
                        on += n.Okres;
                        on14 += n.Okres;
                        break;
                    case PrzyczynaNieobecnosci.UsprawiedliwionaNiepłatna:
                        // urlop bezpłatny (art 174.1 kp)
                        // urlop bezpłatny (kod 350)
                        if (n.Definicja.Guid == new Guid("00000000-0006-0005-0010-000000000000") ||
                            n.Definicja.Guid == new Guid("00000000-0006-0005-0019-000000000000"))
                            on += n.Okres;
                        break;
                    case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
                        Nieobecnosc no = (Nieobecnosc)((OkresNieobecności)n);
                        foreach (WypElement we in no.Elementy) {
                            try {
                                if (we.Definicja.Nazwa.Contains("Zas. chorobowy") ||
                                    we.Definicja.Nazwa.Contains("Zas.chorob.") ||
                                    we.Definicja.Nazwa.Contains("Zas.chorobowy")) {
                                        on += we.Okres * n.Okres;
                                        on14 += we.Okres * n.Okres;
                                }
                            }
                            catch { Msg(); }
                        }
                        break;
            }

            on = on.ToFlat();
            on14 = on14.ToFlat();
            foreach (FromTo ft14 in on14)
                if (ft14.Days <= 14)
                    on -= ft14;

            return on.Days;
        }
            
        public void AddOsoby(PracHistoria ph, KalkulatorPracy kalk) {
            if (!ph.GUS.GlowneMiejscePracy || !EfektywnyOkres(ph).Contains(pars.Okres.To))
                return;
    
            switch (ph.Etat.RodzajZatrudnienia) {
            case RodzajZatrudnienia.NieDotyczy:
            case RodzajZatrudnienia.PracownikTymczasowy:
            case RodzajZatrudnienia.PracownikZaGranicą:
            case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
            case RodzajZatrudnienia.CzłonekRSP:
            case RodzajZatrudnienia.CzłonekSKR:
            case RodzajZatrudnienia.Chałupnik:
            case RodzajZatrudnienia.Właściciel:
            case RodzajZatrudnienia.OsobaWspółpracująca:
            case RodzajZatrudnienia.WięzieńLubAresztowany:
            //Agent
                break;
            default:
                return;
            }
    
            if (!Nieobecny(ph.Pracownik, kalk, pars.Okres.To))
                osoby++;
        }
    
        bool Nieobecny(Pracownik pracownik, KalkulatorPracy kalk, Date to) {
            Periods periods = Periods.Empty;
            Date from = new Date(to.Year, to.Month-2, 1);
            FromTo okres = new FromTo(from, to);
            //1. Wyliczamy ostatni ciągły okres zatrudnienia za ostatnie 3 miesiące
            foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(EfektywnyOkres(pracownik, okres)))
                periods += EfektywnyOkres(ph);
            periods = (periods*okres).ToFlat();
            if (periods==Periods.Empty)
                okres = FromTo.Empty;
            else
                okres = periods[periods.Count-1];
            //2. Wycinamy z niego nieobecności typu urlop bezpłatny i wychowawczy
            periods = Periods.New(okres);
            foreach (INieobecnosc n in kalk.Nieobecnosci(okres, true))
                switch (n.Definicja.Przyczyna) {
                    case PrzyczynaNieobecnosci.UrlopBezpłatny:
                    case PrzyczynaNieobecnosci.UrlopWychowawczy:
                        periods -= n.Okres;
                        break;
                    case PrzyczynaNieobecnosci.UrlopRehabilitacyjny: //TID: 14493
                        if (n.Okres.Contains(okres.To))
                            periods = Periods.Empty;
                        else
                            periods -= n.Okres;
                        break;
                }
            return periods==Periods.Empty;
        }
    
        public object Etaty {
            get {
                decimal w = 0;
                decimal m = pars.Months;
                for (int i=0; i<m; i++)
                    w += wymiar[i];
                w /= m;
                if (srpars.Debug)
					return Soneta.Tools.Math.Round(w, 2);
                return Soneta.Tools.Math.Round(w, 1);
            }
        }

        public object Interwencyjne {
            get {
                decimal w = 0;
                decimal m = pars.Months;
                for (int i = 0; i < m; i++)
                    w += wymiar2[i];
                w /= m;
                if (srpars.Debug)
                    return Soneta.Tools.Math.Round(w, 2);
                return Soneta.Tools.Math.Round(w, 1);
            }
        }
    }

    Dictionary<object, List<Pracownik>> dict = new Dictionary<object, List<Pracownik>>();
    KadryModule kadry;
    static Log trace;
    string title;
    Log log;
		    
    void dc_ContextLoad(Object sender, EventArgs e) {
        ReportHeader["ROK"] = pars.Rok.ToString();
        ReportHeader["KWARTAŁ"] = pars.Kwartał.ToString();
        title = ReportHeader.Title;

        log = new Log();
        trace = null;
        if (traceName != "")
            trace = new Log(traceName, true);

        kadry = KadryModule.GetInstance(dc);
        IEnumerable pracownicy;
        if (srpars.WgListy) {
            ArrayList lista = new ArrayList();
            foreach (Pracownik idx in (Row[])dc[typeof(Row[])])
                lista.Add(idx);
            pracownicy = lista;
        }
        else {
            Soneta.Business.View view = kadry.Pracownicy.CreateView();
            view.ForceAllRows();
            pracownicy = view;
        }

        List<Pracownik> list;
        if (Soneta.Core.Tools.WieloodzialowoscPlatynowa(dc.Session)) {
            Date data = pars.Okres.To;
            foreach (Pracownik pracownik in pracownicy) {
                PracHistoria ph = pracownik[data];
                OddzialFirmy of = ph.Etat.Wydzial != null ? ph.Etat.Wydzial.Oddzial : null;
                while (of != null) {
			        if (of.GetObjectRight() != AccessRights.Denied &&
                        of.Deklaracje.ZUS == NaliczanieDeklaracjiOddziału.Naliczaj)
                        break;
                    of = of.Nadrzedny;
                }
                if (of == null)
                    continue;
                if (!dict.TryGetValue(of, out list))
                    dict.Add(of, list = new List<Pracownik>());
                list.Add(pracownik);
            }
        }
        else {
            dict.Add(string.Empty, list = new List<Pracownik>());
            foreach (Pracownik pracownik in pracownicy)
                list.Add(pracownik);
        }

        DataRepeater1.DataSource = dict.Keys;
    }

	void OnBeforeRow(Object sender, EventArgs args) {
        report = ReportHeader;

        object of = DataRepeater1.CurrentRow;
        if (of is OddzialFirmy)
            report.Title = title.Replace("%ODDZIAL%", "Oddział: " + of);
        else
            report.Title = title.Replace("%ODDZIAL%", "");
    
        string regonFirmy = CoreModule.GetInstance(dc).Config.Firma.Pieczątka.REGON;
		Total total = new Total(regonFirmy, pars, srpars);		
        FromTo okres = pars.Okres;

        int l = 0;
        int m = dict[of].Count;
        
        foreach (Pracownik p in dict[of]) {
            Trace(p);
            log.WriteLine(new Percent(++l, m));
            log.WriteLine(p);            
            
            KalkulatorPracy kalk = new KalkulatorPracy(p);
            foreach (PracHistoria ph in p.Historia.GetIntersectedRows(EfektywnyOkres(p, okres))) {
                total.AddEtaty(ph, kalk);
                total.AddOsoby(ph, kalk);
            }
            total.AddBrutto(p);
        }
    
		regon.EditValue = total.regon=="" ? "&nbsp;" : total.regon;
		etaty.EditValue = total.Etaty;
		osoby.EditValue = total.osoby;
		czas.EditValue = Czas(total.czas);
		brutto.EditValue = Tys(total.brutto);
		spółdzielnie.EditValue = Tys(total.spółdzielnie);
		budżet.EditValue = Tys(total.budżet);
		zus.EditValue = Tys(total.zus);
        interwencyjne.EditValue = total.Interwencyjne;
		//fis.EditValue = Tys(total.fis);
    }
    
    public decimal Tys(decimal value) {
		if (srpars.Debug)
			return value;
		return Soneta.Tools.Math.Round(value/1000m, 1);
    }
    
    public object Czas(Time t) {
		if (srpars.Debug)
			return t;
		return Soneta.Tools.Math.Round(t.TotalHours/1000.0, 1);
    }

    static FromTo EfektywnyOkres(Pracownik p, FromTo okres) {
        foreach (PracHistoria ph in p.Historia.GetIntersectedRows(new FromTo(okres.From, Date.MaxValue)))
            if (ph.Etat.DataPrzejeciaPracownika != Date.Empty) {
                Date dt = okres.To != Date.Empty ? okres.To : Date.MaxValue;
                if (ph.Etat.DataPrzejeciaPracownika <= dt)
                    okres *= new FromTo(ph.Etat.DataPrzejeciaPracownika, dt);
                break;
            }
        return okres;
    }

    static FromTo EfektywnyOkres(PracHistoria ph) {
        FromTo okres = ph.Etat.EfektywnyOkres;
        if (ph.Etat.DataPrzejeciaPracownika != Date.Empty)
            okres *= new FromTo(ph.Etat.DataPrzejeciaPracownika, Date.MaxValue);
        return okres;
    }
    
    static void Msg(object value) {
    }

    static void Trace(object value) {
        if (trace != null)
            trace.WriteLine(value == null ? "(null)" : value.ToString());
    }		        
		    
    public static ReportHeader report;

    public static void Msg() {
        string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
        if (report != null && !report.Title.Contains(msg))
            report.Title += "|" + msg;
    }

		</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form method="post" runat="server">
			<p>
				<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
			    <ea:DataRepeater id="DataRepeater1" runat="server" Width="100%" onbeforerow="OnBeforeRow">
                <ea:PageBreak ID="PageBreak6" runat="server" BreakFirstTimes="False" ResetPageCounter="True"></ea:PageBreak>
				<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Zestawienie dla GUS Z-03|</strong>Rok: <strong>%ROK%|</strong>Kwartał: <strong>%KWARTAŁ%|%ODDZIAL%"
					runat="server"></eb:ReportHeader>
			</p>
			<P>
				<TABLE id="Table1" cellSpacing="1" cellPadding="1" width="100%" border="1">
					<TR>
						<TD align="center" width="20%"><FONT size="2">1. Numer identyfikacyjny - REGON</FONT></TD>
						<TD align="center" width="20%"><FONT size="2">2. Przeciętna liczba zatrudnionych<BR>(z jednym znakiem po przecinku)</FONT></TD>
						<TD align="center" width="20%"><FONT size="2">3. Pracujący w głównym miejscu pracy. Stan w ostatnim dniu kwartału</FONT></TD>
						<TD align="center"><FONT size="2">4. Czas faktycznie przepracowany<BR>
								<STRONG>(w tys. godzin, z jednym znakiem po przecinku)</STRONG></FONT></TD>
					</TR>
					<TR>
						<TD align="center">
							<ea:DataLabel id="regon" runat="server"></ea:DataLabel></TD>
						<TD>
							<P align="right">
								<ea:DataLabel id="etaty" runat="server"></ea:DataLabel></P>
						</TD>
						<TD>
							<P align="right">
								<ea:DataLabel id="osoby" runat="server"></ea:DataLabel></P>
						</TD>
						<TD>
							<P align="right">
								<ea:DataLabel id="czas" runat="server"></ea:DataLabel></P>
						</TD>
					</TR>
				</TABLE>
			</P>
			<P>
				<TABLE id="Table2" cellSpacing="1" cellPadding="1" width="100%" border="1">
					<TR>
						<TD colSpan="4"><FONT size="2">Wynagrodzenie brutto <STRONG>w tys. zł</STRONG> osób 
								wykazanych w pozycji 2</FONT></TD>
					</TR>
					<TR>
						<TD width="60%" colSpan="2"><FONT size="2">ogółem</FONT></TD>
						<TD width="5%">
							<P align="center"><FONT size="2">5</FONT></P>
						</TD>
						<TD>
							<P align="right">
								<ea:DataLabel id="brutto" runat="server"></ea:DataLabel></P>
						</TD>
					</TR>
					<TR>
						<TD width="10%"><FONT size="2">w tym</FONT></TD>
						<TD><FONT size="2">wypłaty z tytułu udziału w zysku lub w nadwyżce bilansowej w 
								spółdzielniach</FONT></TD>
						<TD>
							<P align="center"><FONT size="2">6</FONT></P>
						</TD>
						<TD>
							<P align="right">
								<ea:DataLabel id="spółdzielnie" runat="server"></ea:DataLabel></P>
						</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD><FONT size="2">dodatkowe wynagrodzenie roczne dla pracowników jednostek sfery 
								budżetowej</FONT></TD>
						<TD>
							<P align="center"><FONT size="2">7</FONT></P>
						</TD>
						<TD>
							<P align="right">
								<ea:DataLabel id="budżet" runat="server"></ea:DataLabel></P>
						</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD><FONT size="2">składki na ubezpieczenie emerytalne, rentowe i chorobowe opłacone 
								przez ubezpieczonych</FONT></TD>
						<TD>
							<P align="center"><FONT size="2">8</FONT></P>
						</TD>
						<TD>
							<P align="right">
								<ea:DataLabel id="zus" runat="server"></ea:DataLabel></P>
						</TD>
					</TR>
					<TR>
						<TD><FONT size="2">Z pozycji 2</FONT></TD>
						<TD><FONT size="2">przeciętna liczba pracowników zatrudnionych przy pracach interwencyjnych
                            i robotach publicznych</FONT></TD>
						<TD>
							<P align="center"><FONT size="2">9</FONT></P>
						</TD>
						<TD>
							<P align="right">
								<ea:DataLabel id="interwencyjne" runat="server"></ea:DataLabel></P>
						</TD>
					</TR>
				</TABLE>
			</P>
			<P>
				<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter></P>
			    </ea:DataRepeater>
		</form>
	</body>
</HTML>
